/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.model.TravelersBackpackWearableModel;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackBlockEntityRenderer;
import com.tiviacz.travelersbackpack.common.recipes.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.compat.curios.TravelersBackpackCurios;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import com.tiviacz.travelersbackpack.util.ResourceUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Triple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public TravelersBackpackWearableModel model;

    public TravelersBackpackLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, AbstractClientPlayer clientPlayer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        TravelersBackpackContainer inv;
        if (TravelersBackpackConfig.disableBackpackRender) {
            return;
        }
        if (CapabilityUtils.isWearingBackpack((Player)clientPlayer) && (inv = CapabilityUtils.getBackpackInv((Player)clientPlayer)) != null && !clientPlayer.m_20145_()) {
            if (TravelersBackpackConfig.curiosIntegration && TravelersBackpackCurios.getCurioTravelersBackpack((LivingEntity)clientPlayer).isPresent()) {
                ICuriosItemHandler curios = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)clientPlayer).resolve().get();
                IDynamicStackHandler stackHandler = ((ICurioStacksHandler)curios.getStacksHandler("back").get()).getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    if (!(stackHandler.getStackInSlot(i).m_41720_() instanceof TravelersBackpackItem)) continue;
                    if (((Boolean)((ICurioStacksHandler)curios.getCurios().get("back")).getRenders().get(i)).booleanValue()) {
                        this.renderLayer(poseStack, bufferIn, packedLightIn, clientPlayer, inv, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                        continue;
                    }
                    return;
                }
            }
            ItemStack stack = clientPlayer.m_6844_(EquipmentSlot.CHEST);
            if (!TravelersBackpackConfig.renderBackpackWithElytra) {
                if (stack.m_41720_() instanceof ElytraItem) {
                    return;
                }
                this.renderLayer(poseStack, bufferIn, packedLightIn, clientPlayer, inv, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            } else {
                this.renderLayer(poseStack, bufferIn, packedLightIn, clientPlayer, inv, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        }
    }

    private void renderLayer(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, AbstractClientPlayer clientPlayer, ITravelersBackpackContainer container, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model = new TravelersBackpackWearableModel((LivingEntity)clientPlayer, bufferIn, TravelersBackpackBlockEntityRenderer.createTravelersBackpack(true).m_171564_());
        boolean flag = container.getItemStack().m_41720_() == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || container.getItemStack().m_41720_() == ModItems.SNOW_TRAVELERS_BACKPACK.get();
        ResourceLocation loc = ResourceUtils.getBackpackTexture(container.getItemStack().m_41720_());
        boolean isColorable = false;
        boolean isCustomSleepingBag = false;
        if (container.getItemStack().m_41783_() != null && container.getItemStack().m_41720_() == ModItems.STANDARD_TRAVELERS_BACKPACK.get() && BackpackDyeRecipe.hasColor(container.getItemStack())) {
            isColorable = true;
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed.png");
        }
        if (container.getItemStack().m_41783_() != null && container.getItemStack().m_41783_().m_128441_("SleepingBagColor")) {
            isCustomSleepingBag = true;
        }
        VertexConsumer vertexConsumer = bufferIn.m_6299_(flag ? RenderType.m_110470_((ResourceLocation)loc) : RenderType.m_110446_((ResourceLocation)loc));
        poseStack.m_85836_();
        if (clientPlayer.m_6047_()) {
            poseStack.m_85837_(0.0, -0.155, 0.025);
        }
        ((PlayerModel)this.m_117386_()).m_102872_((HumanoidModel)this.model);
        this.model.setupAngles((PlayerModel)this.m_117386_());
        poseStack.m_85837_(0.0, 0.175, 0.325);
        poseStack.m_85841_(0.85f, 0.85f, 0.85f);
        if (isColorable) {
            Triple<Float, Float, Float> rgb = RenderUtils.intToRGB(BackpackDyeRecipe.getColor(container.getItemStack()));
            this.model.m_7695_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, ((Float)rgb.getLeft()).floatValue(), ((Float)rgb.getMiddle()).floatValue(), ((Float)rgb.getRight()).floatValue(), 1.0f);
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed_extras.png");
            vertexConsumer = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)loc));
        }
        this.model.m_7695_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        loc = isCustomSleepingBag ? ResourceUtils.getSleepingBagTexture(container.getSleepingBagColor()) : ResourceUtils.getDefaultSleepingBagTexture();
        vertexConsumer = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)loc));
        this.model.m_7695_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.25f);
        poseStack.m_85849_();
    }
}

